﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Text.RegularExpressions;
using InSimDotNet.Packets;

namespace Dizplay_Cruise
{
    class Processor
    {
        public static void HistoryAdd(string Title, string Text)
        {
            clsHistory H = new clsHistory();
            H.Title = new Helpers.ItObj(Title, Dizplay.History.Count);
            H.Text = Text;

            Dizplay.History.Add(H);
        }

        public static void InSimErrorRecord(Exception E)
        {
            string Date = DateTime.Now.ToShortDateString() + " " + DateTime.Now.ToLongTimeString();
            string Title = "InSim Error on " + Date;
            string Text = "Message: " + E.Message + Globals.nl + Globals.nl + "StackTrace: " + E.StackTrace + Globals.nl + Globals.nl + "Target: " + E.TargetSite;

            HistoryAdd(Title, Text);
            SendErrorMail(E);
        }

        public static void ErrorRecord(Exception E)
        {
            string Date = DateTime.Now.ToShortDateString() + " " + DateTime.Now.ToLongTimeString();
            string Title = "Error on " + Date;
            string Text = "Message: " + E.Message + Globals.nl + Globals.nl + "StackTrace: " + E.StackTrace + Globals.nl + Globals.nl + "Target: " + E.TargetSite;

            HistoryAdd(Title, Text);
            SendErrorMail(E);

            Dizplay.iSend("^1Error: ^7" + Date);
        }

        public static void ErrorRecord(string Message)
        {
            string Date = DateTime.Now.ToShortDateString() + " " + DateTime.Now.ToLongTimeString();
            string Title = "Error on " + Date;
            string Text = "Message: " + Message;

            HistoryAdd(Title, Text);
            SendErrorMail(Message);

            Dizplay.iSend("^1Error: ^7" + Date);
        }

        public static void SendErrorMail(Exception E)
        {
            string Date = DateTime.Now.ToShortDateString() + " " + DateTime.Now.ToLongTimeString();

            string From = "Dizplay Error Reporter <errors@lmutafov.com>";
            string To = "Dizplay <lmutafov91@gmail.com>";
            string Subject = "Dizplay Error on " + Date;
            string Body =
                "Hello,<br />" +
                "<br />" +
                "This is an automatically generated message, about an error in one of your servers.<br />" +
                "<br />" +
                "<table><tr>" +
                "<td align='left' nowrap='nowrap' valign='top'><b>Server name</b>: </td><td align='left'>" + StripLFSTagsAndColors(Globals.ServerName) + "<br /></td>" +
                "</tr><tr>" +
                "<td align='left' nowrap='nowrap' valign='top'><b>Message</b>: </td><td align='left'>" + E.Message.Replace(Globals.nl, "<br />") + "<br /></td>" +
                "</tr><tr>" +
                "<td align='left' nowrap='nowrap' valign='top'><b>StackTrace</b>: </td><td align='left'>" + E.StackTrace.Replace(Globals.nl, "<br />") + "<br /></td>" +
                "</tr><tr>" +
                "<td align='left' nowrap='nowrap' valign='top'><b>Target</b>: </td><td align='left'>" + E.TargetSite.ToString().Replace(Globals.nl, "<br />") + "<br /></td>" +
                "</tr></table><br />" +
                "<br />" +
                "Regards,<br />" +
                "Dizplay System";

            Vitals.SendMail(From, To, Subject, Body);
        }

        public static void crash()
        {
            //Dizplay.Users.RemoveAt(2354);
            int lol = int.Parse("lol");
        }

        public static void SendErrorMail(string Message)
        {
            string Date = DateTime.Now.ToShortDateString() + " " + DateTime.Now.ToLongTimeString();

            string From = "Dizplay Error Reporter <errors@lmutafov.com>";
            string To = "Dizplay <lmutafov91@gmail.com>";
            string Subject = "Dizplay Error on " + Date;
            string Body =
                "Hello,<br />" +
                "<br />" +
                "This is an automatically generated message, about an error in one of your servers.<br />" +
                "<br />" +
                "<table><tr>" +
                "<td align='left' nowrap='nowrap' valign='top'><b>Server name</b>: </td><td align='left'>" + StripLFSTagsAndColors(Globals.ServerName) + "<br /></td>" +
                "</tr><tr>" +
                "<td align='left' nowrap='nowrap' valign='top'><b>Message</b>: </td><td align='left'>" + Message.Replace(Globals.nl, "<br />") + "<br /></td>" +
                "</tr></table><br />" +
                "<br />" +
                "Regards,<br />" +
                "Dizplay System";

            Vitals.SendMail(From, To, Subject, Body);
        }

        public static void SendCrashMail(Exception E)
        {
            string Date = DateTime.Now.ToShortDateString() + " " + DateTime.Now.ToLongTimeString();

            string From = "Dizplay Crash Reporter <errors@lmutafov.com>";
            string To = "Dizplay <lmutafov91@gmail.com>";
            string Subject = "Dizplay Error on " + Date;
            string Body =
                "Hello,<br />" +
                "<br />" +
                "This is an automatically generated message, about a <b>CRASH</b> in one of your servers.<br />" +
                "<br />" +
                "<table><tr>" +
                "<td align='left' nowrap='nowrap' valign='top'><b>Server name</b>: </td><td align='left'>" + StripLFSTagsAndColors(Globals.ServerName) + "<br /></td>" +
                "</tr><tr>" +
                "<td align='left' nowrap='nowrap' valign='top'><b>Message</b>: </td><td align='left'>" + E.Message.Replace(Globals.nl, "<br />") + "<br /></td>" +
                "</tr><tr>" +
                "<td align='left' nowrap='nowrap' valign='top'><b>StackTrace</b>: </td><td align='left'>" + E.StackTrace.Replace(Globals.nl, "<br />") + "<br /></td>" +
                "</tr><tr>" +
                "<td align='left' nowrap='nowrap' valign='top'><b>Target</b>: </td><td align='left'>" + E.TargetSite.ToString().Replace(Globals.nl, "<br />") + "<br /></td>" +
                "</tr></table><br />" +
                "<br />" +
                "Regards,<br />" +
                "Dizplay System";

            Vitals.SendSyncMail(From, To, Subject, Body);
        }

        /*
        /// <summary>
        /// Adds a button request to the button queue.
        /// </summary>
        /// <param name="Text">The text of the button.</param>
        /// <param name="ButtonStyles">Button style flags.</param>
        /// <param name="H">The height of the button (0 to 200).</param>
        /// <param name="W">The width of the button (0 to 200).</param>
        /// <param name="T">The distance from the top of the screen the button will be displayed (0 to 200).</param>
        /// <param name="L">The distance from the left of the screen the button will be displayed (0 to 200).</param>
        /// <param name="ClickID">Unique button click ID.</param>
        /// <param name="ReqI">Packet request ID.</param>
        /// <param name="UCID">The connection to display the button (0 = local / 255 = all).</param>
        /// <param name="xAlign">Horizontal button alignment</param>
        /// <param name="yAlign">Vertical button alignment</param>
        /// <param name="TypeIn">The maximum characters the user is allowed to type in.</param>
        /// <param name="Caption">The caption for a type-in button.</param>
        /// <param name="Inst">Used internally by insim. (128 = always on top)</param>
        public static void QueueButton(string Text, ButtonStyles ButtonStyles, byte H, byte W, byte T, byte L, byte ClickID, byte ReqI, byte UCID, Globals.xAlign xAlign = Globals.xAlign.left, Globals.yAlign yAlign = Globals.yAlign.top, byte TypeIn = 0, string Caption = "", byte Inst = 0)
        {
            switch (xAlign)
            {
                case Globals.xAlign.center:
                    L = (byte)((100 - W / 2) + L);
                    break;

                case Globals.xAlign.right:
                    L = (byte)((200 - W) - L);
                    break;

            }

            switch (yAlign)
            {
                case Globals.yAlign.middle:
                    T = (byte)((100 - H / 2) + T);
                    break;

                case Globals.yAlign.bottom:
                    T = (byte)((200 - H) - T);
                    break;
            }

            IS_BTN Button1 = new IS_BTN { BStyle = ButtonStyles, ClickID = ClickID, H = H, W = W, L = L, T = T, ReqI = ReqI, Text = Text, TypeIn = TypeIn, Caption = Caption, Inst = Inst, UCID = UCID };
            Button.clsQueue Queue = new Button.clsQueue();
            Queue.Button = Button1;
            Button.Processor.QueueHolder.Add(Queue);
        }*/

        public static string StripLFSColors(string unstrippedString)
        {
            return new Regex(@"\^[0-9]").Replace(unstrippedString, string.Empty);
        }
        public static string StripLFSTags(string unstrippedString)
        {
            return new Regex(@"\^[A-Za-z]").Replace(unstrippedString, string.Empty);
        }
        public static string StripLFSTagsAndColors(string unstrippedString)
        {
            return new Regex(@"\^[0-9A-Za-z]").Replace(unstrippedString, string.Empty);
        }
        public static string ConvertLFSColorsToRtf(string text)
        {
            return "{\\rtf1\\ansi\\deff0{\\fonttbl{\\f0\\fnil\\fcharset0 Calibri;}}" +
                "{\\colortbl ;\\red255\\green0\\blue0;\\red0\\green176\\blue80;\\red255\\green192\\blue0;\\red0\\green77\\blue187;\\red255\\green128\\blue192;\\red75\\green172\\blue198;\\red255\\green255\\blue255;\\red165\\green165\\blue165;\\red102\\green102\\blue102;}" +
                "{\\*\\generator Msftedit 5.41.21.2509;}\\viewkind4\\uc1\\pard\\sa200\\sl276\\slmult1\\lang9\\f0\\fs22" +
                text.Replace(
                        "^1", "\\cf1"
                    ).Replace(
                        "^2", "\\cf2"
                    ).Replace(
                        "^3", "\\cf3"
                    ).Replace(
                        "^4", "\\cf4"
                    ).Replace(
                        "^5", "\\cf5"
                    ).Replace(
                        "^6", "\\cf6"
                    ).Replace(
                        "^7", "\\cf7"
                    ).Replace(
                        "^8", "\\cf8"
                    ).Replace(
                        "^9", "\\cf9"
                    ) +
                " \\par}";
        }

        public static void Send1Object(short X, short Y, short Z, byte Heading, byte Index)
        {
            try
            {
                // Create the AXM packet
                AutoXMultiPacket AXM = new AutoXMultiPacket { Action = ObjectAction.AddObjects };

                // Create the object
                AXM.Objects.Add(new ObjectInfo() { X = X, Y = Y, Z = Z, Heading = Heading, Index = Index, Flags = 0 });

                // Send the packet to LFS
                Dizplay.iSend(AXM);
            }
            catch (Exception E)
            {
                ErrorRecord(E);
            }
        }
    }
}
